<?php

/**
 * SAML 2.0 remote SP metadata for SimpleSAMLphp.
 *
 * See: https://simplesamlphp.org/docs/stable/simplesamlphp-reference-sp-remote
 */

/*
 * Example SimpleSAMLphp SAML 2.0 SP
 */
$metadata['https://saml2sp.example.org'] = [
    'AssertionConsumerService' => 'https://saml2sp.example.org/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp',
    'SingleLogoutService' => 'https://saml2sp.example.org/simplesaml/module.php/saml/sp/saml2-logout.php/default-sp',
];

/*
 * This example shows an example config that works with G Suite (Google Apps) for education.
 * What is important is that you have an attribute in your IdP that maps to the local part of the email address at
 * G Suite. In example, if your Google account is foo.com, and you have a user that has an email john@foo.com, then you
 * must set the simplesaml.nameidattribute to be the name of an attribute that for this user has the value of 'john'.
 */
$metadata['google.com'] = [
    'AssertionConsumerService' => 'https://www.google.com/a/g.feide.no/acs',
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress',
    'simplesaml.nameidattribute' => 'uid',
    'simplesaml.attributes' => false,
];

$metadata['https://legacy.example.edu'] = [
    'AssertionConsumerService' => 'https://legacy.example.edu/saml/acs',
    /*
     * Currently, SimpleSAMLphp defaults to the SHA-256 hashing algorithm.
     * Uncomment the following option to use SHA-1 for signatures directed
     * at this specific service provider if it does not support SHA-256 yet.
     *
     * WARNING: SHA-1 is disallowed starting January the 1st, 2014.
     * Please refer to the following document for more information:
     * http://csrc.nist.gov/publications/nistpubs/800-131A/sp800-131A.pdf
     */
    //'signature.algorithm' => 'http://www.w3.org/2000/09/xmldsig#rsa-sha1',
];
$metadata['https://gestcom.emf-infopro-test.ch/simplesaml/module.php/saml/sp/metadata.php/gestcom-sp'] = array (
  'entityid' => 'https://gestcom.emf-infopro-test.ch/simplesaml/module.php/saml/sp/metadata.php/gestcom-sp',
  'contacts' => 
  array (
  ),
  'metadata-set' => 'saml20-sp-remote',
  'AssertionConsumerService' => 
  array (
    0 => 
    array (
      'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
      'Location' => 'https://gestcom.emf-infopro-test.ch/simplesaml/module.php/saml/sp/saml2-acs.php/gestcom-sp',
      'index' => 0,
    ),
    1 => 
    array (
      'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
      'Location' => 'https://gestcom.emf-infopro-test.ch/simplesaml/module.php/saml/sp/saml1-acs.php/gestcom-sp',
      'index' => 1,
    ),
    2 => 
    array (
      'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
      'Location' => 'https://gestcom.emf-infopro-test.ch/simplesaml/module.php/saml/sp/saml2-acs.php/gestcom-sp',
      'index' => 2,
    ),
    3 => 
    array (
      'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
      'Location' => 'https://gestcom.emf-infopro-test.ch/simplesaml/module.php/saml/sp/saml1-acs.php/gestcom-sp/artifact',
      'index' => 3,
    ),
  ),
  'SingleLogoutService' => 
  array (
    0 => 
    array (
      'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
      'Location' => 'https://gestcom.emf-infopro-test.ch/simplesaml/module.php/saml/sp/saml2-logout.php/gestcom-sp',
    ),
  ),
  'keys' => 
  array (
    0 => 
    array (
      'encryption' => false,
      'signing' => true,
      'type' => 'X509Certificate',
      'X509Certificate' => 'MIIFOjCCA6KgAwIBAgIJAMtiHygSEvFCMA0GCSqGSIb3DQEBCwUAMIGxMQswCQYDVQQGEwJDSDERMA8GA1UECAwIRnJpYm91cmcxETAPBgNVBAcMCEZyaWJvdXJnMQwwCgYDVQQKDANFTUYxGTAXBgNVBAsMEEVNRi1JbmZvcm1hdGlxdWUxJDAiBgNVBAMMG2dlc3Rjb20uZW1mLWluZm9wcm8tdGVzdC5jaDEtMCsGCSqGSIb3DQEJARYebW9yZWlyYWRhc2lsdmFsMDFAc3R1ZGVudGZyLmNoMB4XDTIwMDEyMzA5MjY0N1oXDTMwMDEyMjA5MjY0N1owgbExCzAJBgNVBAYTAkNIMREwDwYDVQQIDAhGcmlib3VyZzERMA8GA1UEBwwIRnJpYm91cmcxDDAKBgNVBAoMA0VNRjEZMBcGA1UECwwQRU1GLUluZm9ybWF0aXF1ZTEkMCIGA1UEAwwbZ2VzdGNvbS5lbWYtaW5mb3Byby10ZXN0LmNoMS0wKwYJKoZIhvcNAQkBFh5tb3JlaXJhZGFzaWx2YWwwMUBzdHVkZW50ZnIuY2gwggGiMA0GCSqGSIb3DQEBAQUAA4IBjwAwggGKAoIBgQC8tdQBNoyI7HxnkU/9ZxfU/bo0u6Iq6+aunEqbnJLDcYEvM9+pYVJcjd2YqIvYH3UdeaJgSNJ3q+tcEcXyfj6TcPn06XLXq1AqBtc1GM5wS8kpV3k27lC1pfv0/O8HENjO4k+gTbcdSirlSbt4Re7UooN0a4GlIrzSx2386ORlFp0LVJAaEyX6rBDqidtqfTK654r6ZlcpJcVDbUBTgi/FfQRxTgnVXJtvvaz6s0+prI2FyRr/p9as9opHrq2sNVD4pOqkOjzJbEo4hdezkDSSm5JCT4MgwI6EAK3u2KjZcjPmXBxjporqkC6DeIc1QcSYFOJenPXS0pjFkyHibchuY1houJDjhIslVvnMCCw8eEIEeATxUAVmv6gQwm4Kc8KRcAhyuzzTL/e9MQEaLM5Thi0ACtKjHMhyCMFdYdulW++lwWNfZn8nlv/13nu9DkroYeqWWbrP/HdyzMnVaPSqzxvxBfdiFir9JfRjSqssdz4uqpDbNdGhffLwNPqG21MCAwEAAaNTMFEwHQYDVR0OBBYEFO44OrZuhP8vliBVjOdzOML07bFAMB8GA1UdIwQYMBaAFO44OrZuhP8vliBVjOdzOML07bFAMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggGBAHBQJEYzuavTecFBfRrxKoGkGIdWKDJ1cNhou4VgL5AlxyMk9AFXWCOiK69Z7B7EZPhQLiDbVBWohuVMArqzzOpPQjTrmBgtdU5JvH1cH6DH8q6TMMRD9I6+lgBY8MI/jL3N45j91GycpGaUwayhq4iNu/lHP1BumaBbjRcwbAUZe1OKEA+a5oi71CXio4M65Hcg/kITfKxe2ZHf8j9BTZVUzozObY0PuU8nlPXVM1T5uvOmATU3URPU0Fe550bR5DuoxLDQ9DdwGylqwuAgxvzITB5dY6VT+R+Y2e1aW+wWC/kI9fVafLodyzo8/xmlf9QDjIOAbxdnhBEN2R8scTzOb972qcpcEjvGdlLO6hIzFnh2OXNNvVhiQwp3kGDhr81dx3jROeXoHflxCtMnH1OPe1uYdrcnXbzctaFCmhz44RRbpQybWM0lO39BS1uCSvFs+sLBWiTGNKD7GLmNMri0uc4T0p3NehBork+xXSaKMZMCSbL0sfzQgOLY0jWmBQ==',
    ),
    1 => 
    array (
      'encryption' => true,
      'signing' => false,
      'type' => 'X509Certificate',
      'X509Certificate' => 'MIIFOjCCA6KgAwIBAgIJAMtiHygSEvFCMA0GCSqGSIb3DQEBCwUAMIGxMQswCQYDVQQGEwJDSDERMA8GA1UECAwIRnJpYm91cmcxETAPBgNVBAcMCEZyaWJvdXJnMQwwCgYDVQQKDANFTUYxGTAXBgNVBAsMEEVNRi1JbmZvcm1hdGlxdWUxJDAiBgNVBAMMG2dlc3Rjb20uZW1mLWluZm9wcm8tdGVzdC5jaDEtMCsGCSqGSIb3DQEJARYebW9yZWlyYWRhc2lsdmFsMDFAc3R1ZGVudGZyLmNoMB4XDTIwMDEyMzA5MjY0N1oXDTMwMDEyMjA5MjY0N1owgbExCzAJBgNVBAYTAkNIMREwDwYDVQQIDAhGcmlib3VyZzERMA8GA1UEBwwIRnJpYm91cmcxDDAKBgNVBAoMA0VNRjEZMBcGA1UECwwQRU1GLUluZm9ybWF0aXF1ZTEkMCIGA1UEAwwbZ2VzdGNvbS5lbWYtaW5mb3Byby10ZXN0LmNoMS0wKwYJKoZIhvcNAQkBFh5tb3JlaXJhZGFzaWx2YWwwMUBzdHVkZW50ZnIuY2gwggGiMA0GCSqGSIb3DQEBAQUAA4IBjwAwggGKAoIBgQC8tdQBNoyI7HxnkU/9ZxfU/bo0u6Iq6+aunEqbnJLDcYEvM9+pYVJcjd2YqIvYH3UdeaJgSNJ3q+tcEcXyfj6TcPn06XLXq1AqBtc1GM5wS8kpV3k27lC1pfv0/O8HENjO4k+gTbcdSirlSbt4Re7UooN0a4GlIrzSx2386ORlFp0LVJAaEyX6rBDqidtqfTK654r6ZlcpJcVDbUBTgi/FfQRxTgnVXJtvvaz6s0+prI2FyRr/p9as9opHrq2sNVD4pOqkOjzJbEo4hdezkDSSm5JCT4MgwI6EAK3u2KjZcjPmXBxjporqkC6DeIc1QcSYFOJenPXS0pjFkyHibchuY1houJDjhIslVvnMCCw8eEIEeATxUAVmv6gQwm4Kc8KRcAhyuzzTL/e9MQEaLM5Thi0ACtKjHMhyCMFdYdulW++lwWNfZn8nlv/13nu9DkroYeqWWbrP/HdyzMnVaPSqzxvxBfdiFir9JfRjSqssdz4uqpDbNdGhffLwNPqG21MCAwEAAaNTMFEwHQYDVR0OBBYEFO44OrZuhP8vliBVjOdzOML07bFAMB8GA1UdIwQYMBaAFO44OrZuhP8vliBVjOdzOML07bFAMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggGBAHBQJEYzuavTecFBfRrxKoGkGIdWKDJ1cNhou4VgL5AlxyMk9AFXWCOiK69Z7B7EZPhQLiDbVBWohuVMArqzzOpPQjTrmBgtdU5JvH1cH6DH8q6TMMRD9I6+lgBY8MI/jL3N45j91GycpGaUwayhq4iNu/lHP1BumaBbjRcwbAUZe1OKEA+a5oi71CXio4M65Hcg/kITfKxe2ZHf8j9BTZVUzozObY0PuU8nlPXVM1T5uvOmATU3URPU0Fe550bR5DuoxLDQ9DdwGylqwuAgxvzITB5dY6VT+R+Y2e1aW+wWC/kI9fVafLodyzo8/xmlf9QDjIOAbxdnhBEN2R8scTzOb972qcpcEjvGdlLO6hIzFnh2OXNNvVhiQwp3kGDhr81dx3jROeXoHflxCtMnH1OPe1uYdrcnXbzctaFCmhz44RRbpQybWM0lO39BS1uCSvFs+sLBWiTGNKD7GLmNMri0uc4T0p3NehBork+xXSaKMZMCSbL0sfzQgOLY0jWmBQ==',
    ),
  ),
);

